<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ReturnbuybilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnbuybilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnbuybilldetail primary key
 	 */
	public function delete($returnbuybilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnbuybilldetail returnbuybilldetail
 	 */
	public function insert($returnbuybilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnbuybilldetail returnbuybilldetail
 	 */
	public function update($returnbuybilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByParcode($value);

	public function queryByReturnbuybillid($value);

	public function queryByReturnbuybilldetailcatid($value);

	public function queryByReturnbuybilldetailproductid($value);

	public function queryByReturnbuybilldetailquantity($value);

	public function queryByReturnbuybilldetailprice($value);

	public function queryByReturnbuybilldetailtotalprice($value);

	public function queryByDiscountvalue($value);

	public function queryByNote($value);


	public function deleteByParcode($value);

	public function deleteByReturnbuybillid($value);

	public function deleteByReturnbuybilldetailcatid($value);

	public function deleteByReturnbuybilldetailproductid($value);

	public function deleteByReturnbuybilldetailquantity($value);

	public function deleteByReturnbuybilldetailprice($value);

	public function deleteByReturnbuybilldetailtotalprice($value);

	public function deleteByDiscountvalue($value);

	public function deleteByNote($value);


}
?>